{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitCursa;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, MMSystem;

type
  TFormCursa = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonCaixaEines: TSpeedButton;
    EditTemps: TEdit;
    ImageCamio: TImage;
    ImageCotxe: TImage;
    CheckBoxLiniesAlMateixLLoc: TCheckBox;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure SpeedButtonCaixaEinesClick(Sender: TObject);
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure CheckBoxLiniesAlMateixLLocClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    ValorDetectat:integer;
    PosicioSegonaLinia:integer;
    procedure PintarIntensitat;
  end;

var
  FormCursa: TFormCursa;

{************************************************}
IMPLEMENTATION
{************************************************}

Uses UnitEntradaSo, UnitCanviDeParametres, UnitTools;

{$R *.DFM}

procedure TFormCursa.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  //if (SpeedButtonEngegarParar.Caption='P') then begin
  if SpeedButtonEngegarParar.Down then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
    SpeedButtonEngegarParar.Enabled:=true;
  end;
end;

procedure TFormCursa.FormCreate(Sender: TObject);
begin
  Top:=0;
  Left:=0;
  Width:=Screen.Width;
  ClientHeight:=Panel.Height+10+128+128;
  ImageCamio.Left:=-ImageCamio.Width;
  ImageCamio.Top:=Panel.Height+128-ImageCamio.Height;
  ImageCotxe.Left:=-ImageCotxe.Width;
  ImageCotxe.Top:=Panel.Height+256-ImageCotxe.Height;
  ValorDetectat:=0;
end;

procedure TFormCursa.FormPaint(Sender: TObject);
begin
  PintarIntensitat;
  Canvas.Pen.Color:=RGB(0,0,0);
  Canvas.MoveTo(0,Panel.Height+128);
  Canvas.LineTo(ClientWidth,Panel.Height+128);
  if CheckBoxLiniesAlMateixLLoc.Checked then PosicioSegonaLinia:=128 else PosicioSegonaLinia:=256;
  Canvas.Pen.Color:=RGB(0,0,0);
  Canvas.MoveTo(0,Panel.Height+PosicioSegonaLinia);
  Canvas.LineTo(ClientWidth,Panel.Height+PosicioSegonaLinia);
end;

procedure TFormCursa.PintarIntensitat;
const
  y = 20;
var
  i,max:integer;
begin
  Canvas.Pen.Color:=RGB(128,0,0);
  Canvas.MoveTo(0,20+y);
  Canvas.LineTo(ValorMinim,20+y);
  Canvas.MoveTo(0,35+y);
  Canvas.LineTo(ValorMinim,35+y);
  i:=0;
  while i<=ValorMinim do begin
    Canvas.MoveTo(i,20+y);
    Canvas.LineTo(i,23+y);
    Canvas.MoveTo(i,35+y);
    Canvas.LineTo(i,32+y);
    i:=i+10;
  end;
  Canvas.Pen.Color:=RGB(0,128,0);
  Canvas.MoveTo(ValorMinim,20+y);
  Canvas.LineTo(ValorMaxim,20+y);
  Canvas.LineTo(ValorMaxim,35+y);
  Canvas.LineTo(ValorMinim,35+y);
  Canvas.LineTo(ValorMinim,20+y);
  while i<=ValorMaxim do begin
    Canvas.MoveTo(i,20+y);
    Canvas.LineTo(i,23+y);
    Canvas.MoveTo(i,35+y);
    Canvas.LineTo(i,32+y);
    i:=i+10;
  end;
  max:=128;
  if ValorMaxim<max then begin
    Canvas.Pen.Color:=RGB(128,0,0);
    Canvas.MoveTo(ValorMaxim,20+y);
    Canvas.LineTo(Max,20+y);
    Canvas.LineTo(Max,35+y);
    Canvas.LineTo(ValorMaxim,35+y);
    while i<=Max do begin
      Canvas.MoveTo(i,20+y);
      Canvas.LineTo(i,23+y);
      Canvas.MoveTo(i,35+y);
      Canvas.LineTo(i,32+y);
      i:=i+10;
    end;
  end;
  Canvas.Pen.Color:=RGB(255,255,255);
  Canvas.MoveTo(0,26+y);
  Canvas.LineTo(128,26+y);
  Canvas.MoveTo(0,27+y);
  Canvas.LineTo(128,27+y);
  Canvas.MoveTo(0,28+y);
  Canvas.LineTo(128,28+y);
  Canvas.MoveTo(0,29+y);
  Canvas.LineTo(128,29+y);
  Canvas.MoveTo(0,30+y);
  Canvas.LineTo(128,30+y);
  if (ValorDetectat<ValorMinim) or (ValorDetectat>ValorMaxim) then Canvas.Pen.Color:=RGB(255,0,0) else Canvas.Pen.Color:=RGB(0,255,0);
  Canvas.MoveTo(0,26+y);
  Canvas.LineTo(ValorDetectat,26+y);
  Canvas.MoveTo(0,27+y);
  Canvas.LineTo(ValorDetectat,27+y);
  Canvas.MoveTo(0,28+y);
  Canvas.LineTo(ValorDetectat,28+y);
  Canvas.MoveTo(0,29+y);
  Canvas.LineTo(ValorDetectat,29+y);
  Canvas.MoveTo(0,30+y);
  Canvas.LineTo(ValorDetectat,30+y);
end;

procedure TFormCursa.WMWIMDATA(var Msg: TMessage);
var
  i,Max:integer;
begin
  Max:=0;
  For i:=1 to BytesBuffer do if so[NumeroBufer,i]-127>Max then Max:=so[NumeroBufer,i]-127;
  ValorDetectat:=Max;
  PintarIntensitat;
  if (Max>=ValorMinim) and (Max<=ValorMaxim) then ImageCotxe.Left:=ImageCotxe.Left+(Max-ValorMinim) div 10;
  ImageCamio.Left:=ImageCamio.Left+IncrementX;
  EditTemps.Text:=FloatToStr(Round((ImageCotxe.Left-ImageCamio.Left)/(20*IncrementX)*100)/100);
  if (ImageCotxe.Left+ImageCotxe.Width>=ClientWidth) or (ImageCamio.Left+ImageCotxe.Width+IncrementX>=ClientWidth) then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
    SpeedButtonEngegarParar.Enabled:=true;
  end else EntradaSo;
end;

procedure TFormCursa.SpeedButtonCaixaEinesClick(Sender: TObject);
begin
  FormCanviDeParametres.ShowModal;
  Repaint;
end;

procedure TFormCursa.SpeedButtonEngegarPararClick(Sender: TObject);
begin
  //if SpeedButtonEngegarParar.Caption='E' then begin
  if SpeedButtonEngegarParar.Down then begin
    SpeedButtonEngegarParar.Caption:='P';
    EditTemps.Text:='0';
    ImageCotxe.Left:=-ImageCotxe.Width;
    ImageCamio.Left:=-ImageCamio.Width;
    IniciarDadesUnitEntradaSo(512);
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
  end;
end;

procedure TFormCursa.CheckBoxLiniesAlMateixLLocClick(Sender: TObject);
begin
  if CheckBoxLiniesAlMateixLLoc.Checked then PosicioSegonaLinia:=128 else PosicioSegonaLinia:=256;
  ImageCotxe.Top:=Panel.Height+PosicioSegonaLinia-ImageCotxe.Height;
  Repaint;
end;


procedure TFormCursa.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

procedure TFormCursa.FormMouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbleft then begin
  end else begin
    if (SpeedButtonEngegarParar.Caption='P') then begin
      PararEntradaSo;
      FinalitzarEntradaSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
      SpeedButtonEngegarParar.Enabled:=true;
    end;
  end;
end;

end.
